Module EventsVB
    Class Point
        Private xcoordinate As Integer
        Private ycoordinate As Integer
        Public Event PointChanged(ByVal x As Integer, ByVal y As Integer)
        Sub New(ByVal x As Integer, ByVal y As Integer)
            xcoordinate = x
            ycoordinate = y
        End Sub
        Public Property X() As Integer
            Get
                Return xcoordinate
            End Get
            Set(ByVal Value As Integer)
                xcoordinate = Value
                RaiseEvent PointChanged(xcoordinate, ycoordinate)
            End Set
        End Property
        Public Property Y() As Integer
            Get
                Return ycoordinate
            End Get
            Set(ByVal Value As Integer)
                ycoordinate = Value
                RaiseEvent PointChanged(xcoordinate, ycoordinate)
            End Set
        End Property
    End Class

    Sub EventHandler(ByVal x As Integer, ByVal y As Integer)
        MessageBox.Show("Punkt zmieni si " & CStr(x) & "," & CStr(y))
    End Sub

    Sub Main()
        Dim p As New Point(1, 2)
        AddHandler p.PointChanged, AddressOf EventHandler
        p.X = 5
    End Sub

End Module
